﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnitySimpleLiquid;

public class FruitItemView : MonoBehaviour
{
    public FruitType m_type;
    //public EndlessContainer m_container;
    public GameObject m_effect;
    public FruitType type => m_type;

    private Vector3 m_size;
    public Vector3 Size => m_size;
    private MeshRenderer m_meshRender;
    private GameObject m_childObj;
    private MeshRenderer[] m_fragTrans;//碎块
    private List<Vector3> m_fragPos = new List<Vector3>();//碎块初始位置
    private List<Quaternion> m_fragQua = new List<Quaternion>();//碎块初始旋转
    private LiquidContainer m_liquidContainer;//流体特效容器
    private Color m_strawberryColor = new Color(1.0f, 57.0f / 255.0f, 30.0f / 255.0f, 160.0f / 255.0f);
    private Color m_lemonColor = new Color(1.0f, 220.0f / 255.0f, 0.0f, 160.0f / 255.0f);
    private Color m_orangeColor = new Color(1.0f, 151.0f / 255.0f, 22.0f / 255.0f, 160.0f / 255.0f);
    private Vector3 m_liquidStartPos;
    private Quaternion m_liquidStartQua;
    private Vector3 m_liquidStartScale;
    private void Awake()
    {
        m_size = transform.localScale;
        m_meshRender = GetComponent<MeshRenderer>();
        m_childObj = transform.GetChild(0).gameObject;
        m_fragTrans = m_childObj.GetComponentsInChildren<MeshRenderer>();
        for(int i = 0;i<m_fragTrans.Length;i++)
        {
            Transform varTrans = m_fragTrans[i].transform;
            m_fragPos.Add(varTrans.localPosition);
            m_fragQua.Add(varTrans.localRotation);
        }
        //if (m_container)
        //{
        //    m_liquidContainer = m_container.gameObject.GetComponent<LiquidContainer>();
        //    m_liquidStartPos = m_container.transform.localPosition;
        //    m_liquidStartQua = m_container.transform.localRotation;
        //    m_liquidStartScale = m_container.transform.localScale;
        //}
        if (m_effect)
        {
            m_liquidStartPos = m_effect.transform.localPosition;
            m_liquidStartQua = m_effect.transform.localRotation;
            m_liquidStartScale = m_effect.transform.localScale;
        }
    }
    //变大动画
    public void SetChangeBig()
    {
        transform.localScale = Vector3.Lerp(transform.localScale, m_size * 1.1f, 1.0f);
    }
    //变小动画
    public void SetChangeSmall()
    {
        transform.localScale = Vector3.Lerp(transform.localScale, m_size, 1.0f);
    }
    //生成流体特效
    //public void SetLiquidEffect()
    //{
    //    m_container.gameObject.SetActive(false);
    //    Transform varObj = m_container.transform.Find("LiquidParticles(Clone)");
    //    if(varObj)
    //    {
    //        Destroy(varObj.gameObject);
    //    }
    //    m_container.enabled = true;
    //    m_liquidContainer.FillAmountPercent = 1.0f;
    //    if (m_liquidContainer)
    //    {
    //        if(m_type == FruitType.Strawberry)
    //        {
    //            m_liquidContainer.LiquidColor = m_strawberryColor;
    //        }
    //        else if(m_type == FruitType.Lemon)
    //        {
    //            m_liquidContainer.LiquidColor = m_lemonColor;
    //        }
    //        else if(m_type == FruitType.Orange)
    //        {
    //            m_liquidContainer.LiquidColor = m_orangeColor;
    //        }
    //    }
    //    m_container.transform.SetParent(null);
    //    Vector3 varVec = transform.position;
    //    varVec.z = 0;
    //    varVec.y += 1.0f;
    //    m_container.transform.localPosition = varVec;
    //    m_container.transform.localRotation = m_liquidStartQua;
    //    m_container.transform.localScale = Vector3.one * 2;
    //    m_container.gameObject.SetActive(true);
    //    Invoke("DelayStopLiquidEffect", 0.5f);
    //}
    ////延迟停止流体特效
    //void DelayStopLiquidEffect()
    //{
    //    m_container.enabled = false;
    //}
    //生成碎块
    public void SetFrag()
    {
        if(m_meshRender)
        {
            m_meshRender.enabled = false;
        }
        if(m_childObj)
        {
            m_childObj.SetActive(true);
        }
        //显示特效
        if (m_effect)
        {
            m_effect.transform.SetParent(null);
            Vector3 varVec = transform.position;
            varVec.z = 0;
            varVec.y += 1.0f;
            m_effect.transform.position = transform.position;
            m_effect.transform.localRotation = m_liquidStartQua;
            m_effect.transform.localScale = m_liquidStartScale;
            m_effect.SetActive(false);
            m_effect.SetActive(true);
        }
    }
    //重置碎块状态
    public void ResetFragState()
    {
        if (m_meshRender)
        {
            m_meshRender.enabled = true;
        }
        if (m_childObj)
        {
            m_childObj.SetActive(false);
        }
        for (int i = 0; i < m_fragTrans.Length; i++)
        {
            m_fragTrans[i].transform.localPosition = m_fragPos[i];
            m_fragTrans[i].transform.localRotation = m_fragQua[i];
        }
        //if (m_effect)
        //{
        //    m_effect.SetActive(false);
        //}
    }
}
